import Utilities.waveform_creator as wc
import Utilities.nidaq_operations as no
import time

channel_name = 'Dev1/ao0'
task = no.create_ao_task(channel_name)

freqs = [440.0, 493.9, 554.4, 587.3, 659.3, 740.0, 830.6, 880.0]


def generate_waveform(freq):

    num, samp_freq = 2000, 4000
    a, f, shape = 5., freq, 'Sine'

    t = wc.create_time_data(num, samp_freq)
    y = wc.create_waveform_data(t, a, f, shape)

    no.config_daq_timing(task,num, 'Continuous', samp_freq)

    task.write(y, auto_start=True)
    time.sleep(1.)
    task.stop()

    return

for freq in freqs:

    generate_waveform(freq)

task.close()
